
<?php

/**
 * Fonctions utiles au plugin Rebonds
 *
 * @plugin     Rebonds
 * @copyright  2025
 * @author     JMarc_64
 * @licence    GNU/GPL
 *
 */

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('inc/config');

/**
 * Fonction de sauvegarde appelée par le cron SPIP
 *
 */
function rebonds_compter_messages() {

		// Lecture du paramétrage du plugin
		$username = lire_config('rebonds/username');
        $password = lire_config('rebonds/password');
        $connexion = lire_config('rebonds/connexion'); 
        $dossier = lire_config('rebonds/dossier');    			
        $expediteur = lire_config('rebonds/expediteur');    			
		$duree = lire_config('rebonds/duree',5);

		// Connexion IMAP à la boite aux lettre recevant la notification d'erreur SMTP
        $inbox = imap_open('{'.$connexion.'}'.$dossier, $username, $password);
		
		if (($expediteur)){
				$from = ' FROM "'.$expediteur.'"';
		}else{
			$from = null;
		}
		$since = ' SINCE "'.date('j F Y H:i:s',strtotime("-$duree day")).'"';
		
        if ($inbox){
			$emails = imap_search($inbox,'UNSEEN'.$from.$since);
                 
			if (!$emails){
				$res=0;
			}else{
				$res=count($emails);
				imap_close($inbox);
				}
			}else{
				$res=imap_last_error();
			}
	return $res;
}