<?php

if (!defined('_ECRIRE_INC_VERSION')) return;


function genie_imap_rebonds_dist($t){
            include_spip('inc/config');
			include_spip('newsletter/feedback');
			
		// Si la configuration est au statut inactif, on shunt le traitement Cron
		if(lire_config('rebonds/etat')==0){
			spip_log(_T('rebonds:info_traitement_inactif'), 'rebonds.'._LOG_INFO_IMPORTANTE);
			return 0;
			}

		// Traitement des échecs SMTP uniquement si campagnes envoyées depuis moins du nombre de jours configuré (5 par défaut)
		$duree = lire_config('rebonds/duree',5);
		$campagnes = sql_allfetsel("*","spip_mailshots", sql_in('statut',array('processing','end')) . " AND date_start>".sql_quote(date('Y-m-d H:i:s',strtotime("-$duree day"))),'','date_start','0,10');
			
		if($campagnes){
			
			// Lecture du paramétrage du plugin
			$username = lire_config('rebonds/username');
            $password = lire_config('rebonds/password');
            $connexion = lire_config('rebonds/connexion'); 
            $dossier = lire_config('rebonds/dossier');    			
            $expediteur = lire_config('rebonds/expediteur');    			
			$prefixe_code = lire_config('rebonds/prefixe_code');
			$prefixe_recipient = lire_config('rebonds/prefixe_recipient');
			$traitement= lire_config('rebonds/traitement');
			$trash= lire_config('rebonds/trash','INBOX.Trash');
         
			// Chargement API Newsletter
			$feedback = charger_fonction("feedback","newsletter");
            
			// Regex pour retrouver les code erreur et l'expéditeur d'origine du message en échec
			$patern_code = $prefixe_code.'.*?((\d+)(?:\.\d+){2})';
			$patern_recipient = $prefixe_recipient.'.*?[^\w\.-]([\w\.=-]+@[\w\.-]+\.[\w]{2,3})';
			
			// Connexion IMAP à la boite aux lettres recevant la notification d'erreur SMTP
            $inbox = imap_open('{'.$connexion.'}'.$dossier, $username, $password);

			if ($expediteur){
					$from = ' FROM "'.$expediteur.'" ';
			}else{
					$from = null;
			}
			$since = ' SINCE "'.date('j F Y H:i:s',strtotime("-$duree day")).'"';
            
			if ($inbox){
					// Lecture boite aux lettres
					if(!$emails = imap_search($inbox,'UNSEEN'.$from.$since)){
					spip_log(_T('rebonds:info_erreur_imap').imap_last_error(), 'rebonds.'._LOG_ERREUR);
					}

					if (!$emails){
					spip_log(_T('rebonds:info_aucune_notification').' '.$username, 'rebonds.'._LOG_INFO_IMPORTANTE);
					return 0;
					}
			
					foreach($campagnes as $campagne){
                            // recuperation l'id campagne
                            $tracking_id = "mailshot".$campagne['id_mailshot'];

                            // traitement des emails
                            if ($emails){
                                    foreach($emails as $email_number) {   
										$message = imap_body($inbox,$email_number);
										$return_code = $type = $original_recipient = null;
		
										// Recherche code erreur
										if (preg_match("/$patern_code/i",$message,$matches)){
											$return_code = $matches[1];
											$type = $matches[2];														
											
											// Recherche l'Original_Recipient
											if (preg_match("/$patern_recipient/i",$message,$matches)){
											$original_recipient = $matches[1];
											}		
										}
										// Vérification de la présence du code erreur ET du destinataire dans le meessage, sinon il est mis en "non lu"
											if (!$type || !$original_recipient){
												if(!imap_clearflag_full($inbox, $email_number, "\\Seen")){
												spip_log(_T('rebonds:info_erreur_imap').imap_last_error(), 'rebonds.'._LOG_ERREUR);							
												}	
											}elseif($row = sql_fetsel("*","spip_mailshots_destinataires","id_mailshot=".intval($campagne['id_mailshot'])." AND email=".sql_quote($original_recipient))){
                                                $event = "";
                                                if ($type == 4 AND $row['statut']!=='fail'){
													$event = 'soft_bounce';
                                                    }
                                                    else if ($type == 5 AND $row['statut']!=='fail'){
                                                            $event = 'hard_bounce';
                                                    }
											// Traitement des Rebonds (bounces)
                                                if ($event) {
														$args = [
														'erreur' => $return_code,
														'event' => $event,
														'adresse' => $original_recipient,
														'liste' => $tracking_id,
														];
														// Execution de l'API Newsletter "newsletter/feedback"
														spip_log(_T('rebonds:info_maj_statut',$args), 'rebonds.'._LOG_INFO_IMPORTANTE);
														$feedback($event,$original_recipient,$tracking_id,true);
													
														// Les notificatons sont mises dans la corbeille ou supprimées définitivement
														if($traitement=='corbeille'){
															if (!imap_mail_move( $inbox, $email_number,$trash)){
																spip_log(_T('rebonds:info_erreur_imap').imap_last_error(), 'rebonds.'._LOG_ERREUR);
															}
														}elseif($traitement=='suppression'){
															if (!imap_delete($inbox, $email_number)){
																spip_log(_T('rebonds:info_erreur_imap').imap_last_error(), 'rebonds.'._LOG_ERREUR);
															}
														}
														imap_expunge (inbox);
                                                    }
                                            }
                                    }
                            }
                    }
                    imap_close($inbox);
            } else {
					spip_log(_T('rebonds:info_erreur_serveur').imap_last_error(), 'rebonds.'._LOG_ERREUR);
            }
       }
	 return 0;
	}
	